/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.taxud.cesop.validation;

import eu.europa.ec.taxud.cesop.domain.MessageTypeEnum;
import eu.europa.ec.taxud.cesop.domain.ValidationError;
import eu.europa.ec.taxud.cesop.domain.ValidationResultTypeEnum;
import eu.europa.ec.taxud.cesop.domain.XmlPaymentDataMsg;
import eu.europa.ec.taxud.cesop.writers.ValidationMessageXmlWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import lombok.Generated;

public class PspValidationResult {
    private final XmlPaymentDataMsg paymentDataMsg;
    private final List<ValidationError> errors;
    private final MessageTypeEnum messageType;

    public ValidationResultTypeEnum getResultType() {
        if (this.errors.isEmpty()) {
            return ValidationResultTypeEnum.VALIDATED;
        }
        if (this.errors.stream().anyMatch(ValidationError::isFullRejection)) {
            return ValidationResultTypeEnum.FULLY_REJECTED;
        }
        return ValidationResultTypeEnum.PARTIALLY_REJECTED;
    }

    public String getResultXml() throws XMLStreamException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ValidationMessageXmlWriter validationMessageXmlWriter = new ValidationMessageXmlWriter(out);){
            validationMessageXmlWriter.createValidationMessage(this.paymentDataMsg, this.errors);
        }
        return out.toString();
    }

    @Generated
    public XmlPaymentDataMsg getPaymentDataMsg() {
        return this.paymentDataMsg;
    }

    @Generated
    public List<ValidationError> getErrors() {
        return this.errors;
    }

    @Generated
    public MessageTypeEnum getMessageType() {
        return this.messageType;
    }

    @Generated
    public PspValidationResult(XmlPaymentDataMsg paymentDataMsg, List<ValidationError> errors, MessageTypeEnum messageType) {
        this.paymentDataMsg = paymentDataMsg;
        this.errors = errors;
        this.messageType = messageType;
    }
}

